<?php
require_once __DIR__ . '/../config.php';

$err = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $is_pro = isset($_POST['is_pro']) ? 1 : 0;

    if (!$username || !$email || !$password) {
        $err = 'Please fill all fields.';
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare('INSERT INTO users (username, email, password_hash, is_pro) VALUES (?,?,?,?)');
        try {
            $stmt->execute([$username, $email, $hash, $is_pro]);
            $_SESSION['user_id'] = $pdo->lastInsertId();
            header('Location: /public/dashboard.php');
            exit;
        } catch (Exception $e) {
            $err = 'Registration failed (maybe username/email taken).';
        }
    }
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Register</title><link rel="stylesheet" href="/assets/style.css"></head><body>
<div class="form-wrapper">
<h2>Register</h2>
<?php if ($err) echo "<p class='error'>$err</p>"; ?>
<form method="post" class="card">
  <label>Username: <input name="username" required></label><br>
  <label>Email: <input name="email" type="email" required></label><br>
  <label>Password: <input name="password" type="password" required></label><br>
  <label><input type="checkbox" name="is_pro"> Register as Pro Trader</label><br>
  <button class="btn">Register</button>
</form>
</div>
</body></html>
