<?php
require_once __DIR__ . '/../config.php';
$err = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if (!$username || !$password) {
        $err = 'Enter username/password.';
    } else {
        $stmt = $pdo->prepare('SELECT id, password_hash FROM users WHERE username = ?');
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user_id'] = $user['id'];
            header('Location: /public/dashboard.php');
            exit;
        } else {
            $err = 'Invalid credentials.';
        }
    }
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Login</title><link rel="stylesheet" href="/assets/style.css"></head><body>
<div class="form-wrapper">
<h2>Login</h2>
<?php if ($err) echo "<p class='error'>$err</p>"; ?>
<form method="post" class="card">
  <label>Username: <input name="username" required></label><br>
  <label>Password: <input name="password" type="password" required></label><br>
  <button class="btn">Login</button>
</form>
</div>
</body></html>
