<?php
require_once __DIR__ . '/../config.php';
require_login();
$me = current_user($pdo);
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Dashboard</title>
  <link rel="stylesheet" href="/assets/style.css">
  <script defer src="/assets/app.js"></script>
</head>
<body>
  <header class="site-header">
    <h1>Dashboard</h1>
    <nav>
      <a href="/public/index.php">Home</a>
      <a href="/public/logout.php">Logout</a>
    </nav>
  </header>
  <main class="container">
    <section class="card">
      <h2>Hello, <?=htmlspecialchars($me['username'])?></h2>
      <p>Balance: <strong><?=number_format($me['balance'],8)?></strong></p>
    </section>

    <section class="card" id="plans-section">
      <h3>Plans</h3>
      <div id="plans"></div>
    </section>

    <section class="card" id="pros-section">
      <h3>Pro Traders</h3>
      <div id="pros"></div>
    </section>

    <?php if ($me['is_pro']): ?>
    <section class="card">
      <h3>Your Pro Controls — Create a trade</h3>
      <form id="trade-form">
        <label>Symbol <input name="symbol" value="BTCUSD"></label>
        <label>Side <select name="side"><option>buy</option><option>sell</option></select></label>
        <label>Quantity <input name="quantity" value="0.01"></label>
        <label>Price <input name="price" value="30000"></label>
        <button class="btn" type="submit">Create Trade</button>
      </form>
      <h4>Your Followers</h4>
      <ul id="my-followers"></ul>
    </section>
    <?php endif; ?>

    <p><a href="/admin/admin.php">Admin Panel</a></p>
  </main>
</body>
</html>
