// Lightweight client JS for dashboard interactivity
document.addEventListener('DOMContentLoaded', () => {
  // load plans (simple)
  fetch('/api/get_pros.php').then(r=>r.json()).then(pros=>{
    const prosDiv = document.getElementById('pros');
    if(!prosDiv) return;
    prosDiv.innerHTML = '';
    pros.forEach(p=>{
      const el = document.createElement('div');
      el.className = 'card';
      el.innerHTML = `<strong>${p.username}</strong>
      <div>
        <label>Copy % <input type="number" value="1.00" min="0" max="100" step="0.25" data-proid="${p.id}" class="copy-input"></label>
        <button class="btn follow-btn" data-proid="${p.id}" data-action="follow">Follow</button>
        <button class="btn" style="background:#bbb;margin-left:8px" data-proid="${p.id}" data-action="unfollow">Unfollow</button>
      </div>`;
      prosDiv.appendChild(el);
    });

    // attach events
    prosDiv.addEventListener('click', async (e)=>{
      if(e.target.matches('.follow-btn')){
        const proId = e.target.dataset.proid;
        const input = prosDiv.querySelector(`.copy-input[data-proid='${proId}']`);
        const copy_pct = parseFloat(input.value) || 1.0;
        await fetch('/api/follow.php', {method:'POST', body: new URLSearchParams({action:'follow', pro_id:proId, copy_pct:copy_pct})});
        alert('Following with copy %: '+copy_pct);
      }
      if(e.target.matches('button') && e.target.dataset.action === 'unfollow'){
        const proId = e.target.dataset.proid;
        await fetch('/api/follow.php', {method:'POST', body: new URLSearchParams({action:'unfollow', pro_id:proId})});
        alert('Unfollowed');
      }
    });
  });

  // trade form submit (if present)
  const tradeForm = document.getElementById('trade-form');
  if(tradeForm){
    tradeForm.addEventListener('submit', async (e)=>{
      e.preventDefault();
      const fd = new FormData(tradeForm);
      const res = await fetch('/api/create_trade.php', {method:'POST', body: fd});
      const j = await res.json();
      if(j.ok) { alert('Trade created and replicated'); window.location.reload(); }
      else alert('Error: '+(j.error||'unknown'));
    });
  }
});
