<?php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); echo json_encode(['error'=>'Only POST']); exit; }
if (empty($_SESSION['user_id'])) { http_response_code(401); echo json_encode(['error'=>'Not logged in']); exit; }

$action = $_POST['action'] ?? '';
$pro_id = intval($_POST['pro_id'] ?? 0);
$copy_pct = floatval($_POST['copy_pct'] ?? 1.0);
$follower_id = $_SESSION['user_id'];

if (!$pro_id) { http_response_code(400); echo json_encode(['error'=>'Missing pro_id']); exit; }

if ($action === 'follow') {
    $stmt = $pdo->prepare('INSERT INTO followers (pro_id, follower_id, copy_pct) VALUES (?,?,?) ON DUPLICATE KEY UPDATE copy_pct = VALUES(copy_pct)');
    $stmt->execute([$pro_id, $follower_id, $copy_pct]);
    echo json_encode(['ok'=>true]);
    exit;
} elseif ($action === 'unfollow') {
    $stmt = $pdo->prepare('DELETE FROM followers WHERE pro_id=? AND follower_id=?');
    $stmt->execute([$pro_id, $follower_id]);
    echo json_encode(['ok'=>true]);
    exit;
} else {
    http_response_code(400);
    echo json_encode(['error'=>'Unknown action']);
    exit;
}
