<?php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); echo json_encode(['error'=>'Only POST']); exit; }
if (empty($_SESSION['user_id'])) { http_response_code(401); echo json_encode(['error'=>'Not logged in']); exit; }

$me_id = $_SESSION['user_id'];
// check pro
$stmt = $pdo->prepare('SELECT is_pro FROM users WHERE id=?');
$stmt->execute([$me_id]);
$user = $stmt->fetch();
if (!$user || !$user['is_pro']) { http_response_code(403); echo json_encode(['error'=>'Not a pro']); exit; }

$symbol = substr(trim($_POST['symbol'] ?? ''), 0, 50);
$side = ($_POST['side'] === 'sell') ? 'sell' : 'buy';
$quantity = floatval($_POST['quantity'] ?? 0);
$price = floatval($_POST['price'] ?? 0);

if (!$symbol || $quantity <= 0 || $price <= 0) { http_response_code(400); echo json_encode(['error'=>'Invalid data']); exit; }

$pdo->beginTransaction();
$stmt = $pdo->prepare('INSERT INTO trades (pro_id, symbol, side, quantity, price) VALUES (?,?,?,?,?)');
$stmt->execute([$me_id, $symbol, $side, $quantity, $price]);
$trade_id = $pdo->lastInsertId();

// replicate to followers using their configured copy_pct
$stmt = $pdo->prepare('SELECT follower_id, copy_pct FROM followers WHERE pro_id = ?');
$stmt->execute([$me_id]);
$followers = $stmt->fetchAll();

$ins = $pdo->prepare('INSERT INTO replicated_trades (trade_id, follower_id, pro_id, symbol, side, quantity, price) VALUES (?,?,?,?,?,?,?)');
foreach ($followers as $f) {
    $rep_qty = $quantity * (floatval($f['copy_pct']) / 100.0);
    if ($rep_qty <= 0) continue;
    $ins->execute([$trade_id, $f['follower_id'], $me_id, $symbol, $side, $rep_qty, $price]);
    // optionally: update follower balance in realistic ways (omitted)
}

$pdo->commit();
echo json_encode(['ok'=>true, 'trade_id'=>$trade_id]);
