<?php
require_once __DIR__ . '/../config.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_plan'])) {
    $name = $_POST['name'];
    $days = intval($_POST['duration']);
    $rate = floatval($_POST['rate']);
    $min = floatval($_POST['min']);
    $stmt = $pdo->prepare('INSERT INTO plans (name, duration_days, rate_percent, min_amount) VALUES (?,?,?,?)');
    $stmt->execute([$name, $days, $rate, $min]);
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Admin</title>
  <link rel="stylesheet" href="/assets/style.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
  <main class="container">
    <h2>Admin — Plans & Analytics</h2>
    <section class="card">
      <h3>Create Plan</h3>
      <form method="post">
        <input name="name" placeholder="Plan name" required>
        <input name="duration" placeholder="Duration days" required>
        <input name="rate" placeholder="Rate percent" required>
        <input name="min" placeholder="Min amount" required>
        <button class="btn" name="create_plan">Create</button>
      </form>
    </section>

    <section class="card">
      <h3>Quick Analytics</h3>
      <canvas id="statsChart" width="400" height="200"></canvas>
      <script>
        async function loadStats(){
          const res = await fetch('/api/stats.php');
          const j = await res.json();
          const ctx = document.getElementById('statsChart').getContext('2d');
          new Chart(ctx, {
            type: 'bar',
            data: {
              labels: ['Users','Trades','Replicated Trades'],
              datasets: [{ label: 'Counts', data: [j.users, j.trades, j.replicated] }]
            }
          });
        }
        loadStats();
      </script>
    </section>
  </main>
</body>
</html>
